//=============================================================================
// InventoryDestroyer
//
// Can destroy player's weapons or all inventory
//
// Players tend to dislike this - use sparingly
// (For example: a mission with massive rewards, to compensate any loss)
//=============================================================================
Class InventoryDestroyer extends MPConvo_Trigger;

var(MPC_InventoryDestroyer) bool bOnlyDestroyWeapons;

function DoCoolStuff(DeusExPlayer Instigator)
{
	local Inventory inv;
	local DeusExWeapon wep;

	if(bOnlyDestroyweapons == false)
	{
		foreach AllActors(class 'Inventory', inv)
		{
			if(inv.Owner == Instigator)
			{
				inv.Destroy();
			}
		}
	}
	else
	{
		foreach AllActors(class 'DeusExWeapon', wep)
		{
			if(wep.Owner == Instigator)
			{
				wep.Destroy();
			}
		}
	}
}

defaultproperties
{
}